% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fclust.R
\name{plot_ftrees}
\alias{plot_ftrees}
\title{Plot trees resulting from functional clustering}
\usage{
plot_ftrees(fres, nbcl = 0, main = "Title", opt.tree = NULL )
}
\arguments{
\item{fres}{an object generated by the function \code{\link{fclust}}.}

\item{nbcl}{an integer.
The integer indicates the number of component clusters
to take into account.
It can be lower than or equals to
the optimum number \code{fres$nbOpt} of component clusters.}

\item{main}{a string, that is used
as the first, reference part of the title of each graph.}

\item{opt.tree}{a list, that can include
\code{opt.tree = list("cal", "prd", cols, "zoom", window, "all")}.
This option list manages the plot of primary and secondary trees
of component clustering,
simplified or not, focussed on the main component clusters or not,
coloured by the user or not.
The item order in list is any. \cr

\itemize{
 \item{\code{"cal"}}{  plots the primary tree of component clustering,
  from trunk until leaves.
  At trunk level, when all components are clustered
  into a large, trivial cluster,
  the coefficient of determination \code{R2} is low.
  At the leaves level, when each component is isolated in a singleton,
  the coefficient of determination is always equal to \code{1}.
  The primary tree is therefore necessarily over-fitted
  near the leaves level.
  The optimum number \code{fres$nbOpt} of component clusters
  is determined by the minimum \code{AICc}.

  The blue dashed line indicates the level
  (optimum number \code{fres$nbOpt} of component clusters)
  where the tree must be optimally cut up.
  The red solid line indicates the value of tree efficiency \code{E}
  at the \code{nbcl}-level.
  The component clusters are named by lowercase letters,
  from left to right as \code{"a", "b", "c", ...}:
  the name and content of each component cluster
  is written on the following page.
  }

\item{\code{"prd"}}{  plots the validated,
  secondary tree of component clustering,
  from trunk until validated leaves.
  Secondary tree is the primary tree cut
  at the level of the optimal number \code{nbOpt} of component clusters.
  \code{nbOpt} is determined
  by the first lowest value of \code{AIC} along the primary tree.

  The red solid line indicates the value of tree efficiency \code{E}.
  \code{R2} and \code{E} are stored in \code{fres$tStats}.
  The component clusters are named by lowercase letters,
  from left to right as \code{"a", "b", "c", ...}:
  the name and content of each component cluster
  is written on the following page.
  }

\item{\code{cols}}{  is a vector of colours, characters or integers,
  of same length as the number of components. This option specifies
  the colour of each component.
  The components labelled by the same integer
  have the same colour. If \code{cols} is not specified,
  the components that belong to a same cluster
  \emph{a posteriori} determined have the same colour.
  This option is useful when an \emph{a priori} clustering is known,
  to identify the components \emph{a priori} clustered
  into the \emph{a posteriori} clustering.
  }

\item{\code{"zoom"}}{ if \code{"cal"} or \code{"prd"} is checked,
  this option allows
  to only plot the first, significant component clusters.
  The cluster on the far right (the cluster named by the last letter)
  is most often a large cluster, that includes many components
  of which the effects of assemblage performance are not significant.
  When the number of components is large, the tree is dense
  and the names of components are confusing.
  The option is useful to focus on the left, more signficant,
  part of the primary or secondary tree.
  If \code{"zoom"} is checked, \code{window} must be informed.
  If not, the function stops with an error message.
  Note that the large cluster, that includes many components,
  is always represented by at least one component.
  }

\item{\code{window}}{  an integer, that
  specifies the number of components to plot.
  \code{window} must be informed when \code{"zoom"} is checked.
  If \code{window} is higher than the number of components, it is ignored.
  If \code{window} is lower than the number of significant components,
  it is ajusted in such a way that the large cluster,
  that includes many components,
  is at least represented by one component.
  }

\item{\code{"all"}}{  plots all possible graphs.
  This option is equivalent to
  \code{opt.tree = list("cal", "prd", "zoom", window = 20)}.
  If the number of components is lower than 20,
  the option is equivalent to \code{opt.tree = list("cal", "prd")}.
  }
}}
}
\value{
Nothing. It is a procedure.
}
\description{
The function plots
primary and secondary hierarchical trees of component clustering.
}
\details{
None.
}
\seealso{
\code{\link{plot_ftrees}} plot primary and secondary trees
 resulting from functional clustering \cr
\code{\link{plot_fperf}} plot observed, modelled and predicted performances
 resulting from functional clustering \cr
\code{\link{plot_fass}} plot performances of some given assemblages \cr
\code{\link{plot_fmotif}} plot as boxplot mean performances
of assemblages sorted by assembly motifs \cr
\code{\link{plot_fcomp}} plot as boxplot mean performances
of assemblages containing a given component \cr
\code{\link{fclust_plot}} plot all possible outputs
of functional clustering
}
\keyword{internal}
