% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labelling.R
\name{name_clusters}
\alias{name_clusters}
\title{Labelling (by lowercase letters) of components by cluster}
\usage{
name_clusters(affectElt)
}
\arguments{
\item{affectElt}{a vector of integers.
The vector contains the labels of the different functional groups
to which each component belongs.
Each functional group is labelled as an integer.}
}
\value{
Return a vector of strings
corresponding to names of components by clusters.
}
\description{
Take a vector of component affectation by clusters,
then name the components by cluster.
}
\details{
General:\cr
A hierarchical tree is recorded
as a list of matrix of component affectation
and a vector of coefficients of determination.
The matrix of component affectation is a square matrix.
Its dimension is "number of leaves" = "number of components".
The clusters of components are labelled by integers, an integer by cluster.
The first line of the square matrix corresponds to the trivial cluster.
The trivial cluster get together all the components:
all components are thus labelled by one.
The second line separates the trivial cluster into 2 sub-clusters:
the components are labelled 1 or 2
according to the cluster to which they belong.
The following lines separate the trivial cluster into n sub-clusters,
labelled from 1 to the line numero.
The last line separate each component in a singleton cluster.\cr

 A set of \code{s} components generates \code{m = 2^s - 1 assembly motifs}.
The clusters of components are previously shifted by \code{shift_affectElt},
for sorting clusters from the most efficient cluster
 (labelled \code{a}, on the left),
its size is generally smaller than the least efficient clusters,
towards the least efficient clusters
 (labelled \code{m' < m}, on the right).
 component clusters are thus labelled: \code{a, b, c, ... m' < m}.

Each assembly motif is a combination of clusters.
The assembly motifs are simply labelled
as the combination of clusters that they contain:
\code{a, b, c, ..., ab, ac bc, ..., abc ...}.

The order of all vectors of strings is
this of the input vector \code{affectElt}.
}
\keyword{internal}
