% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_fclust.R
\name{fboot_write_one_point}
\alias{fboot_write_one_point}
\title{Record a test of significance of functional clustering}
\usage{
fboot_write_one_point(fres, rboot, filename)
}
\arguments{
\item{fres}{an object resulting from a functional clustering
obtained using the function \code{\link{fclust}}.}

\item{rboot}{a list of matrices resulting from the functions
\code{fboot_assemblages}, \code{fboot_performances}
or \code{fboot_one_point}.}

\item{filename}{a string, used as radical for naming the file
\code{"filename.components.csv"}, \code{"filemane.assemblages.csv"}
or \code{"filemane.performances.csv"}
according to the dimensions of matrices.}
}
\value{
Nothing. It is a procedure.
}
\description{
Record in a file the results of
a test of significance of functional clustering.
}
\details{
The functions
  \code{fboot_assemblages}, \code{ftest_performances}
  and \code{fboot_one_point}
  generate a list containing a matrix by clustering index
  ("Czekanowski_Dice", "Folkes_Mallows", "Jaccard", "Kulczynski",
  "Precision", "Rand", "Recall", "Rogers_Tanimoto", "Russel_Rao",
  "Sokal_Sneath1" and "Sokal_Sneath2" index).
  Only their dimensions change according the used functions.
  Consequently, a same function is used for recording and reading
  the results of both the test-functions.
}
\keyword{internal}
