% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labelling.R
\name{compact_index}
\alias{compact_index}
\title{Compact a vector of indices}
\usage{
compact_index(v)
}
\arguments{
\item{v}{a vector of integers, used as indices.}
}
\value{
Return a vector of integer,
that can be browsed by the code \code{seq_len(length(unique(v)))}.
}
\description{
Take a vector \code{v} of indices,
then simplify the indexing system
and compact it from \code{1} to \code{length(unique(v))}.
}
\details{
The indexing vector \code{v} is simplified
and compacts from \code{1} to \code{length(unique(v))}.
The index order is not changed, only the labels are changed.
The function is useful
for debugging computations on values sorted by a program.
}
\keyword{internal}
