% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validating_jack.R
\name{amean_byelt_jack}
\alias{amean_byelt_jack}
\title{Arithmetic mean
 by elements occurring within assembly motif
 using jackknife method}
\usage{
amean_byelt_jack(fobs, mOccur, jack)
}
\arguments{
\item{fobs}{a numeric vector. The vector \code{fobs} contains the
quantitative performances of assemblages.}

\item{mOccur}{a matrix of occurrence (occurrence of elements).
Its first dimension equals to \code{length(fobs)}. Its second dimension
 equals to the number of elements.}

\item{jack}{an integer vector of length \code{2}.
The vector specifies the parameters for jackknife method.
The first integer \code{jack[1]} specifies the size of subset,
the second integer \code{jack[2]} specifies the number of subsets.}
}
\description{
Take a numeric vector and return the predicted vector
computed as the arithmetic mean
of all elements belonging to a same assembly motif.
}
\details{
Modelled performances are computed
using arithmetic mean (\code{opt.mean = "amean"}) of performances.
Assemblages share a same assembly motif (\code{opt.model = "bymot"}).
Modelled performances are the average
of mean performances of assemblages that contain the same elements
as the assemblage to predict,
except a subset of assemblages.
This procedure corresponds to a linear model with each assembly motif
based on the element occurrence in each assemblage.

The assemblages belonging to a same assembly motif are divided
 into \code{jack[2]} subsets of \code{jack[1]} assemblages.
  Prediction is computed by excluding \code{jack[1]} assemblages,
  including the assemblage to predict.
   If the total number of assemblages belonging
  to the assembly motif is lower than \code{jack[1]*jack[2]},
   prediction is computed by leave-one-out (LOO).
}
\seealso{
\code{\link{amean_bymot_jack}},
         \code{\link{gmean_bymot_jack}},
         \code{\link{gmean_byelt_jack}}
}
\keyword{internal}
