% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_fault_detection.R
\name{get_ooc}
\alias{get_ooc}
\title{Get out of control observations from control charts}
\usage{
get_ooc(cclist)
}
\arguments{
\item{cclist}{A \code{data.frame} produced by
\code{\link{control_charts_pca}}, \code{\link{control_charts_sof_pc}},
\code{\link{regr_cc_fof}}, or \code{\link{regr_cc_sof}}.}
}
\value{
A \code{data.frame} with the same number of rows as cclist,
and the same number of columns
apart from the columns indicating control chart limits.
Each value is TRUE if the corresponding observation is in control
and FALSE otherwise.
}
\description{
Get out of control observations from control charts
}
\examples{
library(funcharts)
data("air")
air <- lapply(air, function(x) x[201:300, , drop = FALSE])
fun_covariates <- c("CO", "temperature")
mfdobj_x <- get_mfd_list(air[fun_covariates],
                         n_basis = 15,
                         lambda = 1e-2)
y <- rowMeans(air$NO2)
y1 <- y[1:60]
y2 <- y[91:100]
mfdobj_x1 <- mfdobj_x[1:60]
mfdobj_x_tuning <- mfdobj_x[61:90]
mfdobj_x2 <- mfdobj_x[91:100]
mod <- sof_pc(y1, mfdobj_x1)
cclist <- control_charts_sof_pc(mod = mod,
                                y_test = y2,
                                mfdobj_x_test = mfdobj_x2,
                                mfdobj_x_tuning = mfdobj_x_tuning)
get_ooc(cclist)


}
