% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_Xfgpm_Class.R
\name{summary,Xfgpm-method}
\alias{summary,Xfgpm-method}
\title{Summary method for \code{Xfgpm} objects}
\usage{
\S4method{summary}{Xfgpm}(object, n = 24, ...)
}
\arguments{
\item{object}{A \code{Xfgpm} object.}

\item{n}{Maximal number of lines (\code{fgpm} objects) to show.}

\item{...}{Not used yet.}
}
\value{
An object inheriting from \code{list}, actually a list
    containing one or two data frames depending on the number of
    inputs. In each data frame, the \code{n} rows provide
    information on the best \code{fgpm} objects visited.
}
\description{
Display a summary of the structure of a \code{Xfgpm}
    object, with a short description of up to \code{n} \code{fgpm}
    objects visited during the ACO optimization.
}
\details{
The displayed information depends on the number of
    candidate inputs, in order to maintain compact tables.  The
    inputs are labelled with integer suffixes, the prefix being
    \code{"X"} for scalar inputs and \code{"F"} for functional
    inputs.
    \itemize{
        \item{With a small number of inputs, the list
              contains only one data frame. For each candidate
              input (either scalar or functional) a column with
              the input name indicates if the input
              is active (cross \code{x}) or not (white space)
              in the \code{fgpm} object corresponding to the row. For each
              functional variable also shown are: the distance used \code{D_},
              the dimension \code{Bas_} after dimension reduction,
              the type of basis used \code{B_}. Remind that the
              kernel (\code{Kern}) is the same for all functional
              inputs. Also shown is the value of the Leave-One-Out
              coefficient \code{Q²}.
        }
        \item{With a large number of inputs, the list contains
              two data frames. The first one tells which inputs
              are active among the scalar and functional candidate
              inputs. The second data frame gives more details
              for functional inputs as before.}
      }
}
\examples{
summary(xm)
}
