% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EGAAComposition.R
\name{EGAAComposition}
\alias{EGAAComposition}
\title{Enhanced Grouped Amino Acid Composition}
\usage{
EGAAComposition(
  seqs,
  winSize = 50,
  overLap = TRUE,
  Grp = "locFus",
  label = c(),
  outFormat = "mat",
  outputFileDist = ""
)
}
\arguments{
\item{seqs}{is a FASTA file with amino acid sequences. Each sequence starts
with a '>' character. Also, seqs could be a string vector. Each element of the vector is a peptide/protein sequence.}

\item{winSize}{shows the size of sliding window. It is a numeric value.}

\item{overLap}{This parameter shows how the window
moves on the sequence. If the overlap is set to TRUE, the next window would have distance 1 with
the previous window. Otherwise, the next window will start from the next amino acid after the previous window.
There is no overlap between the next and previous windows.}

\item{Grp}{is a list of vectors containig amino acids. Each vector represents a category. Users can define a customized amino acid grouping, provided that the sum of all amino acids is 20 and there is no repeated amino acid in the groups.
Also, users can choose 'cTriad'(conjointTriad), 'locFus', or 'aromatic'. Each option provides specific information about the type of an amino acid grouping.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}

\item{outFormat}{(output format) can take two values: 'mat'(matrix) and 'txt'. The default value is 'mat'.}

\item{outputFileDist}{shows the path and name of the 'txt' output file.}
}
\value{
The output depends on the outFormat parameter which can be either 'mat' or 'txt'. If outFormat is 'mat', the function returns a feature
matrix for sequences with the same length such that the number of columns is ((number of categorizes) * (number of windows))
and the number of rows is equal to the number of sequences. It is usable for machine learning purposes.
If the outFormat is 'txt', the output is written to a tab-delimited file.
}
\description{
In this function, amino acids are first grouped into user-defined categories. Then, enhanced grouped amino acid composition is computed.
For details about the enhanced feature, please refer to function \link{EAAComposition}.
Please note that this function differs from function \link{EAAComposition} which works on individual amino acids.
}
\examples{

dir = tempdir()
ptmSeqsADR<-system.file("extdata/",package="ftrCOOL")
ptmSeqsVect<-as.vector(read.csv(paste0(ptmSeqsADR,"/ptmVect101AA.csv"))[,2])
mat1<-EGAAComposition(seqs = ptmSeqsVect,winSize=20,overLap=FALSE,Grp="locFus")

mat2<-EGAAComposition(seqs = ptmSeqsVect,winSize=30,overLap=FALSE,Grp=
list(Grp1=c("G","A","V","L","M","I","F","Y","W"),Grp2=c("K","R","H","D","E")
,Grp3=c("S","T","C","P","N","Q")),outFormat="mat")

ad<-paste0(dir,"/EGrpaaCompos.txt")
filePrs<-system.file("extdata/proteins.fasta",package="ftrCOOL")
EGAAComposition(seqs = filePrs,winSize=20,Grp="cTriad",outFormat="txt"
,outputFileDist=ad)

}
