% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spa_functions.R
\name{spa_core}
\alias{spa_core}
\title{Capturing the core of a \code{pgeometry} object}
\usage{
spa_core(pgo)
}
\arguments{
\item{pgo}{A \code{pgeometry} object of any type.}
}
\value{
An \code{sfg} object that represents the core of \code{pgo}. It can be an empty object if \code{pgo} does not have a component with membership degree 1.
}
\description{
This function yields a crisp spatial object (as an \code{sfg} object) that corresponds to the core of a \code{pgeometry} object given as input.
}
\details{
It employs the classical definition of \emph{core} from the fuzzy set theory in the context of spatial plateau algebra.
The \emph{core} only comprises the points with membership degree equal to 1.
Hence, this operation returns the \code{sfg} object that represents the component labeled with
membership degree equal to 1 of the \code{pgeometry} object given as input. If the \code{pgeometry} object has no core, then an empty \code{sfg} object is returned (i.e., a crisp spatial object without points).
}
\examples{

library(sf)

pts1 <- rbind(c(1, 2), c(3, 2))
pts2 <- rbind(c(1, 1), c(2, 3), c(2, 1))
pts3 <- rbind(c(2, 2), c(3, 3))

cp1 <- component_from_sfg(st_multipoint(pts1), 0.3)
cp2 <- component_from_sfg(st_multipoint(pts2), 0.6)
cp3 <- component_from_sfg(st_multipoint(pts3), 1.0)

pp <- create_pgeometry(list(cp1, cp2, cp3), "PLATEAUPOINT")
pp

pp_core <- spa_core(pp)
pp_core

#Creating a pgeometry object without core
pp2 <- create_pgeometry(list(cp1, cp2), "PLATEAUPOINT")
pp2

spa_core(pp2)

}
\references{
\href{https://ieeexplore.ieee.org/document/7737976}{Carniel, A. C.; Schneider, M. A Conceptual Model of Fuzzy Topological Relationships for Fuzzy Regions. In Proceedings of the 2016 IEEE International Conference on Fuzzy Systems (FUZZ-IEEE 2016), pp. 2271-2278, 2016.}
}
