% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlay2.R
\name{multi_overlay}
\alias{multi_overlay}
\title{Create Multi-Image Plot with Overlays}
\usage{
multi_overlay(x, y = NULL, z = NULL, w = 1, mask = NULL,
  col.x = gray(0:64/64), col.y = hotmetal(), zlim.x = NULL,
  zlim.y = NULL, plane = c("axial", "coronal", "sagittal"), xlab = "",
  ylab = "", axes = FALSE, direction = c("horizontal", "vertical"),
  par.opts = list(oma = c(0, 0, 0, 0), mar = rep(0, 4), bg = "black"),
  text = NULL, text.x = NULL, text.y = NULL, text.cex = 1,
  text.col = "white", main = NULL, main.col = text.col,
  main.cex = text.cex, NA.x = TRUE, NA.y = TRUE, ...)
}
\arguments{
\item{x}{List of images of class \code{nifti} or character vector of filenames}

\item{y}{List of images of class \code{nifti} or character vector of filenames.
Same length as \code{x}.}

\item{z}{Slice to display.}

\item{w}{3D volume to display if \code{x} has 4-D elements}

\item{mask}{\code{nifti} image to drop empty image dimensions if wanted. 
Passed to \code{\link{dropEmptyImageDimensions}}}

\item{col.x}{Color to display x images}

\item{col.y}{Color to display y images}

\item{zlim.x}{Limits for \code{x} to plot}

\item{zlim.y}{Limits for \code{y} to plot}

\item{plane}{the plane of acquisition to be displayed}

\item{xlab}{Label for x-axis}

\item{ylab}{Label for y-axis}

\item{axes}{Should axes be displayed}

\item{direction}{Should images be a row or column? Ignored if 
\code{mfrow} is in \code{par.opts}}

\item{par.opts}{Options to pass to \code{\link{par}}}

\item{text}{Text to be displayed}

\item{text.x}{Location of text in x-domain}

\item{text.y}{Location of text in y-domain}

\item{text.cex}{Multiplier for text font}

\item{text.col}{Color for \code{text} and \code{main}.}

\item{main}{Title for each plot}

\item{main.col}{Color for \code{main}. Will default to \code{text.col}}

\item{main.cex}{Multiplier for text font. Will default to \code{text.cex}}

\item{NA.x}{Should \code{0}'s in \code{x} be set to \code{NA}?}

\item{NA.y}{Should \code{0}'s in \code{y} be set to \code{NA}?}

\item{...}{Additional arguments to pass to \code{\link[graphics]{image}}}
}
\description{
Creates a multi-row or multi-column plot with image
slices and the potential for overlays as well.
}
\examples{
\dontrun{

 if (require(brainR)) {
   library(scales)
   visits = 1:3
   y = paste0("Visit_", visits, ".nii.gz")
   y = system.file(y, package = "brainR")
   y = lapply(y, readnii)

   y = lapply(y, function(r){
     pixdim(r) = c(0, rep(1, 3), rep(0, 4))
     dropImageDimension(r)
   })

   x = system.file("MNI152_T1_1mm_brain.nii.gz", 
                 package = "brainR")
   x = readnii(x)
   mask = x >0
   x = lapply(visits, function(tmp){
       x
   })

   multi_overlay(x, y, 
         col.y = alpha(hotmetal(), 0.5),
         mask = mask, 
         main = paste0("\\n", "Visit ", visits),
         text = LETTERS[visits],
         text.x = 0.9,
         text.y = 0.1,
         text.cex = 3)
 }
}
}

