% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3objectsdoc.R
\name{tclusticsol.object}
\alias{tclusticsol.object}
\title{Objects returned by the function \code{\link{tclustICsol}}}
\value{
The functions \code{print()} and \code{summary()} are used to obtain and print a
 summary of the results. An object of class \code{tclusticsol} is a list containing at least the following components:
 \item{call}{the matched call}
 \item{kk}{a vector containing the values of \code{k} (number of components) which have been considered.
     This vector is identical to the optional argument \code{kk} (default is \code{kk=1:5}.}
 \item{cc}{a vector containing the values of \code{c} (values of the restriction factor) which
     have been considered. This vector is identical to the optional argument \code{cc} (defalt is \code{cc=c(1, 2, 4, 8, 16, 32, 64, 128)}.}
 \item{alpha}{trimming level}
 \item{whichIC}{Information criteria used}
 \item{MIXMIXbs}{a matrix of lists of size \code{NumberOfBestSolutions-times-5} which
 contains the details of the best solutions for MIXMIX (BIC). Each row refers to a
 solution. The information which is stored in the columns is as follows.
 \itemize{
 \item 1st col = value of k for which solution takes place
 \item 2nd col = value of c for which solution takes place;
 \item 3rd col = a vector of length \code{d} which contains the values of \code{c}
     for which the solution is uniformly better.
 \item 4th col = a vector of length \code{d + r} which contains the values of \code{c}
     for which the solution is considered stable (i.e. for which the value
     of the adjusted Rand index (or the adjusted Fowlkes and Mallows index)
     does not go below the threshold defined in input option \code{ThreshRandIndex}).
 \item 5th col = string which contains 'true' or 'spurious'. The solution is labelled
     spurious if the value of the adjusted Rand index with the previous solutions
     is greater than ThreshRandIndex.
 }

 Remark: the field MIXMIXbs is present only if \code{whichIC=ALL} or \code{whichIC="MIXMIX"}.
 }
 \item{MIXMIXbsari}{a matrix of adjusted Rand indexes (or Fowlkes and Mallows indexes)
     associated with the best solutions for MIXMIX. A matrix of size \code{NumberOfBestSolutions-times-NumberOfBestSolutions}
     whose \code{i,j}-th entry contains the adjusted Rand index between classification produced by solution
     \code{i} and solution \code{j}, \code{i,j=1,2, ...,NumberOfBestSolutions}.

 Remark: the field \code{MIXMIXbsari} is present only if \code{whichIC=ALL} or \code{whichIC="MIXMIX"}.
 }
 \item{ARIMIX}{a matrix of adjusted Rand indexes between two consecutive value of \code{c}.
     Matrix of size \code{k-by-length(cc)-1}. The first column contains the ARI indexes
     between \code{cc[2]} and \code{cc[1]} given \code{k}.
     The second column contains the the ARI indexes between \code{cc[3]} and \code{cc[2]} given \code{k}.

 Remark: the field \code{ARIMIX} is present only if \code{whichIC=ALL} or \code{whichIC="MIXMIX"} or \code{whichIC="MIXCLA"}.
 }
 \item{MIXCLAbs}{has the same structure as \code{MIXMIXbs} but referres to MIXCLA.

 Remark: the field MIXCLAbs is present only if \code{whichIC=ALL} or \code{whichIC="MIXCLA"}.
 }
 \item{MIXCLAbsari}{has the same structure as \code{MIXMIXbsari} but referres to MIXCLA.

 Remark: the field \code{MIXMIXbsari} is present only if \code{whichIC=ALL} or \code{whichIC="MIXCLA"}.
 }
 \item{CLACLAbs}{has the same structure as \code{MIXMIXbs} but referres to CLACLA.

 Remark: the field CLACLAbs is present only if \code{whichIC=ALL} or \code{whichIC="CLACLA"}.
 }
 \item{CLACLAbsari}{has the same structure as \code{MIXMIXbsari} but referres to CLACLA.

 Remark: the field \code{CLACLAbsari} is present only if \code{whichIC=ALL} or \code{whichIC="CLACLA"}.
 }
 \item{ARICLA}{a matrix of adjusted Rand indexes between two consecutive value of \code{c}.
     Matrix of size \code{k-by-length(cc)-1}. The first column contains the ARI indexes
     between \code{cc[2]} and \code{cc[1]} given \code{k}.
     The second column contains the the ARI indexes between \code{cc[3]} and \code{cc[2]} given \code{k}.

 Remark: the field \code{ARICLA} is present only if \code{whichIC=ALL} or \code{whichIC="CLACLA"}.
 }
}
\description{
An object of class \code{\link{tclusticsol.object}} holds information about
 the result of a call to \code{\link{tclustICsol}}.
}
\examples{

 \dontrun{
 data(hbk)
 (out <- tclustIC(hbk[, 1:3]))

  ## Plot first two best solutions using as Information criterion MIXMIX
  print("Best solutions using MIXMIX")
  outMIXMIX <- tclustICsol(out, whichIC="MIXMIX", plot=TRUE, NumberOfBestSolutions=2)
  class(outMIXMIX)
  summary(outMIXMIX)
  print(outMIXMIX$MIXMIXbs)
 }
}
\seealso{
\code{\link{tclustICsol}}, \code{\link{carbikeplot}}
}
\keyword{multivariate}
\keyword{robust}
