% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbar.R
\name{vis.seg.legend}
\alias{vis.seg.legend}
\title{Plot legend for a brain volume segmentation based on colorLUT.}
\usage{
vis.seg.legend(colortable, segvol, ...)
}
\arguments{
\item{colortable}{a colortable data.frame, or a character string, which will be treated as a filename and loaded with \code{\link[freesurferformats]{read.fs.colortable}}. Typically \code{FS_HOME/FreeSurferColorLUT.txt}.}

\item{segvol}{optional 3D or 4D array of integer data, the brain segmentation. Or a character string, which will be treated as a filename and loaded with \code{\link[freesurferformats]{read.fs.volume}}. If given, only colortable entries which actually occur in the volume data are plotted. If \code{NULL}, all entries are plotted, which may be a lot.}

\item{...}{passed on to \link{vis.colortable.legend}}
}
\description{
Plot legend for a brain volume segmentation based on colorLUT.
}
\examples{
\dontrun{
ct = file.path(fs.home(), "FreeSurferColorLUT.txt");
seg = file.path(fs.home(), "subjects", "fsaverage", "mri", "aseg.mgz");
vis.seg.legend(ct, seg);

}

}
