% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{fsSimilarityMatrix}
\alias{fsSimilarityMatrix}
\title{Constructing the similarity matrix}
\usage{
fsSimilarityMatrix(feature.sets, threshold, method)
}
\arguments{
\item{feature.sets}{a list of matrixes that contains weights for features, estimated by several feature selection algorithms.}

\item{threshold}{the required sparsity of the resulting feature set}

\item{method}{a similarity metric. Directly passed to \code{\link{fsSimilarity}} function}
}
\value{
returns a real-valued square matrix with pairwise similarity metric values of feature sets
}
\description{
\code{fsSimilarityMatrix} constructs a square matrix of similarity metric values between MTS feature sets.
Metrics are calculated using \code{\link{fsSimilarity}} function with cutting-off feature sets
}
\examples{

# Load traffic data
data(traffic.mini)

# Scaling is sometimes useful for feature selection
# Exclude the first column - it contains timestamps
data <- scale(traffic.mini$data[,-1])

mIndep<-fsMTS(data, max.lag=3, method="ownlags")
mCCF<-fsMTS(data, max.lag=3, method="CCF")
mDistance<-fsMTS(data, max.lag=3, method="distance", shortest = traffic.mini$shortest, step = 5)
mGLASSO<-fsMTS(data, max.lag=3,method="GLASSO", rho = 0.05)
mLARS<-fsMTS(data, max.lag=3,method="LARS")
mRF<-fsMTS(data, max.lag=3,method="RF")
mMI<-fsMTS(data, max.lag=3,method="MI")
mlist <- list(Independent = mIndep,
              Distance = mDistance,
              CCF = mCCF,
              GLASSO = mGLASSO,
              LARS = mLARS,
              RF = mRF,
              MI = mMI)

(msimilarity <- fsSimilarityMatrix(mlist,threshold = 0.3, method="Kuncheva"))

}
\seealso{
\code{\link{fsSimilarity}}
}
