% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{buildFAO}
\alias{buildFAO}
\title{Estimate the coefficients for the recommended FAO equation}
\usage{
buildFAO(dw, temp, tmin)
}
\arguments{
\item{dw}{[°C]: an array of dew points, two hours after sunset.}

\item{temp}{[°C]: an array of ambient temperature, two hours after sunset.}

\item{tmin}{[°C]: minimum temperature}
}
\value{
A FAOFrostModel object with a, b, and c values, which can be used to estimate minimum temperature (Tmin) using temp
and dw. This function also returns Tp (predicted temperature using the equation), Rp (residuals, the
difference between tmin given and Tp) and r2 which is the coefficient of correlation (R squared).
}
\description{
Estimate the coefficients for the recommended FAO equation using: ambient temperature
and dew point taken two hours after sunset, and minimum  daily temperature, which
were taken in nights with radiative frost
(wind less than 2 m/s^2, no clouds, no fog, no rain).
}
\details{
The method was extracted from the documentation and previous implementation in FFST.xls file,
which is name in the book
"Frost Protection: fundamentals, practice, and economics. Volume 1.
Authors: Richard L Snyder, J. Paulo de Melo-Abreu.
Food and Agriculture Organization of the United Nations. 2005"

This function implements the method, resolve the equation and find the coefficients.
Equation: Tmim = a * temp + b * dw + c
where "temp"  and "dw" are the temperature and dew point respectively, which must be taken
two hours after sunset

For more details please check:
<http://www.fao.org/docrep/008/y7223e/y7223e0b.htm#bm11.8>
<http://www.fao.org/docrep/008/y7223e/y7223e0b.htm>
FFST spreasheet <http://biomet.ucdavis.edu/frostprotection/FTrend/FFST_FTrend.htm>
}
\examples{
x1 <- rnorm(100,mean=2,sd=5)
x2 <- rnorm(100,mean=1,sd=3)
y <- rnorm(100,mean=0,sd=2)
buildFAO(dw = x2,temp=x1,tmin=y)
#data example taken from FAO Book
t0 <- c(3.2,0.8,0.2,2.6,4.4,5.2,2.7,1.2,4.5,5.6) # temperature 2 hours after sunset
td <- c(-4.2,-8.8,-6.5,-6.2,-6.1,2.6,-0.7,-1.7,-1.2,0.1) # dew point 2 hours after sunset
tn <- c(-3.1,-5,-6.3,-5.4,-4,-2.5,-4.8,-5,-4.4,-3.3)
buildFAO(dw = td,temp=t0,tmin=tn)
}
