% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_fs_curv.R
\name{write.fs.morph.ni2}
\alias{write.fs.morph.ni2}
\title{Write morphometry data in NIFTI v2 format.}
\usage{
write.fs.morph.ni2(filepath, data, ...)
}
\arguments{
\item{filepath}{string, the full path of the output NIFTI file. Should end with '.nii' or '.nii.gz'.}

\item{data}{numerical vector, the data to write. Will be coerced to double.}

\item{...}{extra parameters passed to \code{\link{write.nifti2}}.}
}
\value{
format, string. The format that was used to write the data: "ni2".
}
\description{
Write morphometry data in NIFTI v2 format.
}
\note{
Not many software packages support NIFTI v2 format. If possible with your data, you may want to use NIFTI v1 instead.
}
\seealso{
\code{\link{nifti.file.version}} can be used to check whether a file is NIFTI v1 or v2 file.

Other morphometry functions: 
\code{\link{fs.get.morph.file.ext.for.format}()},
\code{\link{fs.get.morph.file.format.from.filename}()},
\code{\link{read.fs.curv}()},
\code{\link{read.fs.mgh}()},
\code{\link{read.fs.morph.gii}()},
\code{\link{read.fs.morph}()},
\code{\link{read.fs.volume}()},
\code{\link{read.fs.weight}()},
\code{\link{write.fs.curv}()},
\code{\link{write.fs.label.gii}()},
\code{\link{write.fs.mgh}()},
\code{\link{write.fs.morph.asc}()},
\code{\link{write.fs.morph.gii}()},
\code{\link{write.fs.morph.ni1}()},
\code{\link{write.fs.morph.smp}()},
\code{\link{write.fs.morph.txt}()},
\code{\link{write.fs.morph}()},
\code{\link{write.fs.weight.asc}()},
\code{\link{write.fs.weight}()}

Other nifti2 writers: 
\code{\link{write.nifti2}()}
}
\concept{morphometry functions}
\concept{nifti2 writers}
