% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredr_series_search_related_tags.R
\name{fredr_series_search_related_tags}
\alias{fredr_series_search_related_tags}
\title{Get the related FRED tags for one or more FRED tags matching a series search}
\usage{
fredr_series_search_related_tags(
  series_search_text,
  tag_names,
  ...,
  exclude_tag_names = NULL,
  tag_group_id = NULL,
  tag_search_text = NULL,
  limit = NULL,
  offset = NULL,
  order_by = NULL,
  sort_order = NULL,
  realtime_start = NULL,
  realtime_end = NULL
)
}
\arguments{
\item{series_search_text}{A string containing the series search text.}

\item{tag_names}{A semicolon delimited string of tag names to return.}

\item{...}{These dots only exist for future extensions and should be empty.}

\item{exclude_tag_names}{A semicolon delimited string of tag names that
series match \emph{none} of.  Defaults to no tag filtering.}

\item{tag_group_id}{A string indicating the tag group id to filter tags by type.
Defaults to no filtering by tag group.  Possible values are
\itemize{
\item \code{"freq"} = Frequency
\item \code{"gen"} = General or Concept
\item \code{"geo"} = Geography
\item \code{"geot"} = Geography Type
\item \code{"rls"} = Release
\item \code{"seas"} = Seasonal Adjustment
\item \code{"src"} = Source
}}

\item{tag_search_text}{A string to match tag names.  Defaults to no filtering
by tag name matching.}

\item{limit}{An integer limit on the maximum number of results to return.
Defaults to \code{1000}, the maximum.}

\item{offset}{An integer used in conjunction with \code{limit} for long series.
This mimics the idea of \emph{pagination} to retrieve large amounts of data over
multiple calls. Defaults to \code{0}.}

\item{order_by}{A string indicating the attribute to order results by.
Defaults to \code{"series_count"}. Possible values are:
\itemize{
\item \code{"series_count"}
\item \code{"popularity"}
\item \code{"created"}
\item \code{"name"}
\item \code{"group_id"}
}}

\item{sort_order}{A string representing the order of the resulting series.
Possible values are: \code{"asc"} (default), and \code{"desc"}.}

\item{realtime_start}{A \code{Date} indicating the start of the real-time period.
Defaults to today's date. For more information, see
\href{https://fred.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}

\item{realtime_end}{A \code{Date} indicating the end of the real-time period.
Defaults to today's date. For more information, see
\href{https://fred.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}
}
\value{
A \code{tibble} object.
}
\description{
FRED tags are attributes assigned to series.  Return the \emph{related} FRED tags
for a search: tags assigned to series that match \emph{all} tags in the \code{tag_names}
parameter (required), \emph{no} tags in the \code{exclude_tag_names} (optional) and the
search words set by the \code{series_search_text} parameter (required).
}
\examples{
if (fredr_has_key()) {
# Search for all tags matching the series text "oil" and the tag "usa".
fredr_series_search_related_tags(
  series_search_text = "oil",
  tag_names = "usa"
)
# Search for tags matching the series text "oil", the tag text "usa", and
# are related to the tag "usa".  Return only results in the "src" (Source)
# group.
fredr_series_search_related_tags(
  series_search_text = "oil",
  tag_names = "usa",
  tag_group_id = "src",
  tag_search_text = "usa"
)
}
}
\references{
API Documentation:

\href{https://fred.stlouisfed.org/docs/api/fred/series_search_related_tags.html}{series/search/related_tags}
}
\seealso{
\code{\link[=fredr_series_observations]{fredr_series_observations()}}, \code{\link[=fredr_series_search_text]{fredr_series_search_text()}},
\code{\link[=fredr_series_search_id]{fredr_series_search_id()}}, \code{\link[=fredr_series_search_tags]{fredr_series_search_tags()}},
\code{\link[=fredr_series]{fredr_series()}}, \code{\link[=fredr_series_categories]{fredr_series_categories()}},
\code{\link[=fredr_series_release]{fredr_series_release()}}, \code{\link[=fredr_series_tags]{fredr_series_tags()}}, \code{\link[=fredr_series_updates]{fredr_series_updates()}},
\code{\link[=fredr_series_vintagedates]{fredr_series_vintagedates()}}.
}
