% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredr_set_key.R
\name{fredr_set_key}
\alias{fredr_set_key}
\title{Set the FRED API key}
\usage{
fredr_set_key(key)
}
\arguments{
\item{key}{A valid FRED API key as a string.  Obtain one at the
\href{https://api.stlouisfed.org/api_key.html}{API Keys} page.}
}
\description{
Users of the \code{fredr} package must authenticate with the FRED API by use of
an API key. The function \code{fredr_set_key()} sets the FRED API key as an
environment variable for use with the service.  For persistence across sessions,
see the Details section.
}
\details{
\code{fredr_set_key()} sets a key as an environment variable for use with
the \code{fredr} package in the current session.  The key can also be set in the
\code{.Renviron} file at the user or project level scope.  You can edit the file manually by
appending the line \code{FRED_API_KEY = my_api_key}, where \code{my_api_key} is your
actual key (remember to not surround the key in quotes).  The function
\code{usethis::edit_r_environ()} does this safely.  Run
\code{base::readRenviron(".Renviron")} to set the key in the current session
or restart R for it to take effect. The variable will be set in subsequent
sessions in the working directory if you set it with project level scope,
or everywhere if you set it with user level scope.
}
\examples{
current_key <- Sys.getenv("FRED_API_KEY")
fredr_set_key("abcdefghijklmnopqrstuvwxyz123456")
Sys.getenv("FRED_API_KEY")
fredr_set_key(current_key)
Sys.getenv("FRED_API_KEY")

}
\references{
See St. Louis Fed Web Services \href{https://api.stlouisfed.org/api_key.html}{API Keys}
to obtain an API key.
}
\seealso{
Note that by using a FRED API key, you agree to the FRED API
\href{https://research.stlouisfed.org/docs/api/terms_of_use.html}{Terms of Use}.
}
