% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/FNN.Methods.R
\name{HyFIS}
\alias{HyFIS}
\title{HyFIS model building}
\usage{
HyFIS(data.train, num.labels, max.iter = 10, step.size = 0.01,
  type.tnorm = "MIN", type.snorm = "MAX", type.defuz = "COG",
  type.implication.func = "ZADEH")
}
\arguments{
\item{data.train}{a matrix (\eqn{m \times n}) of normalized data for the training process,
 where \eqn{m} is the number of instances and
 \eqn{n} is the number of variables; the last column is the output variable.
Note the data must be normalized between 0 and 1.}

\item{num.labels}{a matrix (\eqn{1 \times n}), whose elements represent the number of labels (linguistic terms);
\eqn{n} is the number of variables.}

\item{max.iter}{the maximal number of iterations.}

\item{step.size}{step size of the gradient descent method.}

\item{type.tnorm}{the type of t-norm. For more detail, please have a look at \code{\link{inference}}.}

\item{type.snorm}{the type of s-norm. For more detail, please have a look at \code{\link{inference}}.}

\item{type.defuz}{the type of aggregation function. For more detail, please have a look at \code{\link{defuzzifier}}}

\item{type.implication.func}{a value representing type of implication function. For more detail, please have a look at \code{\link{WM}}}
}
\description{
This is the internal function that implements the hybrid neural fuzzy inference
system (HyFIS). It is used to solve regression tasks.
Users do not need to call it directly,
but just use \code{\link{frbs.learn}} and \code{\link{predict}}
}
\details{
This method was proposed by J. Kim and N. Kasabov. There are two phases in
this method for learning, namely the knowledge acquisition module and the
structure and parameter learning.
The knowledge acquition module uses the techniques of Wang and Mendel.
The learning of structure and parameters is a supervised learning method using
gradient descent-based learning algorithms.
This function generates a model which consists of a rule database and parameters
of the membership functions. The rules of HyFIS use the Mamdani model on the antecedent and
consequent parts. Futhermore,
HyFIS uses a Gaussian membership function. So, there are two kinds of
parameters that are optimized, mean and variance of the Gaussian function.
}
\references{
J. Kim and N. Kasabov, "HyFIS: Adaptive neuro-fuzzy inference systems and
their application to nonlinear dynamical systems",
Neural Networks, vol. 12, no. 9, pp. 1301 - 1319 (1999).
}
\seealso{
\code{\link{HyFIS.update}}, \code{\link{frbs.learn}}, and \code{\link{predict}}.
}

