% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setters.R
\name{set_fct}
\alias{set_fct}
\title{set factor}
\usage{
set_fct(.data, ..., first_level = NULL, order_fct = FALSE)
}
\arguments{
\item{.data}{dataframe}

\item{...}{tidyselect (default selection: all character columns)}

\item{first_level}{character string to set the first level of the factor}

\item{order_fct}{logical. ordered factor?}
}
\value{
tibble
}
\description{
allows option to manually set the first level of the factor, for consistency with
yardstick which automatically considers the first level
as the "positive class" when evaluating classification.
}
\examples{

## simply set the first level of a factor

iris$Species \%>\% levels

iris \%>\%
  set_fct(Species, first_level = "virginica") \%>\%
  dplyr::pull(Species) \%>\%
  levels()
}
