% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logisticfragilityinternal.R
\name{logisticfragilityinternal}
\alias{logisticfragilityinternal}
\title{Logistic fragility internal function}
\usage{
logisticfragilityinternal(formula, data, covariate, conf.level = 0.95)
}
\arguments{
\item{formula}{Model formula which will be evaluated by glm()}

\item{data}{Dataframe with values for model forma, passed to glm()}

\item{covariate}{Covarite name (string) whose fragility you would like to test}

\item{conf.level}{Significance level, set by default to 95\%}
}
\value{
Returns the fragility index for a single run
}
\description{
Compute the fragility of a coefficient in a logistic regression for dichotomous outcomes. This function is called by the wrapper function logistic.fragility(), which replicates this function many times to obtain more stable estimates.
}
\examples{
mydata <- read.csv("http://www.ats.ucla.edu/stat/data/binary.csv")
mydata$rank <- factor(mydata$rank)
logisticfragilityinternal(admit ~ gre + gpa + rank, data = mydata, covariate="gre")

}

