% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assessment_glance.R
\name{assessment_glance}
\alias{assessment_glance}
\title{Obtain tidy summary information for a floristic quality assessment}
\usage{
assessment_glance(data_set)
}
\arguments{
\item{data_set}{A data set downloaded from
\href{https://universalfqa.org/}{universalfqa.org} either manually or using
\code{\link[=download_assessment]{download_assessment()}}}
}
\value{
A data frame with 52 columns:
\itemize{
   title (character)
   date (date)
   site_name (character)
   city (character)
   county (character)
   state (character)
   country (character)
   fqa_db_region (character)
   fqa_db_publication_year (character)
   fqa_db_description (character)
   custom_fqa_db_name (character)
   custom_fqa_db_description (character)
   practitioner (character)
   latitude (character)
   longitude (character)
   weather_notes (character)
   duration_notes (character)
   community_type_notes (character)
   other_notes (character)
   private_public (character)
   total_mean_c (numeric)
   native_mean_c (numeric)
   total_fqi (numeric)
   native_fqi (numeric)
   adjusted_fqi (numeric)
   c_value_zero (numeric) Percent of c-values 0
   c_value_low (numeric) Percent of c-values 1-3
   c_value_mid (numeric) Percent of c-values 4-6
   c_value_high (numeric) Percent of c-values 7-10
   native_tree_mean_c (numeric)
   native_shrub_mean_c (numeric)
   native_herbaceous_mean_c (numeric)
   total_species (numeric)
   native_species (numeric)
   non_native_species (numeric)
   mean_wetness (numeric)
   native_mean_wetness (numeric)
   tree (numeric)
   shrub (numeric)
   vine (numeric)
   forb (numeric)
   grass (numeric)
   sedge (numeric)
   rush (numeric)
   fern (numeric)
   bryophyte (numeric)
   annual (numeric)
   perennial (numeric)
   biennial (numeric)
   native_annual (numeric)
   native_perennial (numeric)
   native_biennial (numeric)
}
}
\description{
\code{assessment_glance()} tidies a floristic quality assessment data set
obtained from \href{https://universalfqa.org/}{universalfqa.org}.
}
\examples{
# While assessment_glance can be used with a .csv file downloaded manually
# from the universal FQA website, it is most typically used in combination
# with download_assessment().

edison <- download_assessment(25002)
assessment_glance(edison)

}
