% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transect_inventory.R
\name{transect_inventory}
\alias{transect_inventory}
\title{Obtain species details for a floristic quality transect assessment}
\usage{
transect_inventory(data_set)
}
\arguments{
\item{data_set}{A data set downloaded from
\href{https://universalfqa.org/}{universalfqa.org} either manually or using
\code{\link[=download_transect]{download_transect()}}.}
}
\value{
A data frame with 13 columns:
\itemize{
  \item Species (character)
  \item Family (character)
  \item Acronym (character)
  \item Nativity (character)
  \item C (numeric)
  \item W (numeric)
  \item Physiognomy (character)
  \item Duration (character)
  \item Frequency (numeric)
  \item Coverage (numeric)
  \item Relative Frequency % (numeric)
  \item Relative Coverage % (numeric)
  \item Relative Importance Value (numeric)
}
}
\description{
\code{transect_inventory()} returns a data frame of all plant species
included in a floristic quality transect assessment obtained from
\href{https://universalfqa.org/}{universalfqa.org}.
}
\examples{
# while transect_glance can be used with a .csv file downloaded
# manually from the universal FQA website, it is most typically used
# in combination with download_transect().
\donttest{
tyler <- download_transect(6352)
transect_inventory(tyler)
}

}
