% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscfuns.R
\name{fit.off}
\alias{fit.off}
\title{Closes the current plotting device and shows the result in the viewer}
\usage{
fit.off()
}
\description{
To be used in combination with \code{\link[fplot]{pdf_fit}} or \code{\link[fplot]{png_fit}} when exporting images. It performs exactly the same thing as \code{dev.off()} but additionaly shows the resulting graph in the viewer pane provided you're using RStudio.
}
\details{
To view the results of PDF exports, the function \code{pdf_convert} from package \code{pdftools} is used to convert the PDF files into images -- so you need to have installed \code{pdftools} to make it work.

In PDFs, only the first page will be viewed.
}
\examples{

# Exportation example
# The functions pdf_fit, png_fit, etc, guarantee the right
#  point size of the texts present in the graph.
# But you must give the exact size the graph will take in your final document.
# => first use the function setFplot_page, default is:
# setFplot_page(page = "us", margins = "normal")
# By default the graph takes 100\% of the text width

data(us_pub_econ)

tmpFile = file.path(tempdir(), "DISTR -- institutions.png")

png_fit(tmpFile)
plot_distr(~institution, us_pub_econ)
fit.off()

# What's the consequence of increasing the point size of the text?
png_fit(tmpFile, pt = 15)
plot_distr(~institution, us_pub_econ)
fit.off()


}
\seealso{
The tool to set the page size and the exporting defaults: \code{\link[fplot]{setFplot_page}}. Exporting functions \code{\link[fplot]{pdf_fit}}, \code{\link[fplot]{png_fit}}, \code{\link[fplot]{jpeg_fit}}.
}
\author{
Laurent Berge
}
