% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_peaks.R
\name{find_peaks}
\alias{find_peaks}
\title{find_peaks}
\usage{
find_peaks(x, win = 5, verbose = TRUE)
}
\arguments{
\item{x}{A matrix as outputed by \code{densify}}

\item{win}{A positive integer specifying the window length on
either side of a peak (i.e. win 5 will give a total window of 11 -
-5 indices + peak index + 5 indices)}

\item{verbose}{A logical determining if function progress
should be reported}
}
\value{
A list of four, the first three positions containing lists
of the peak indices for each taxon, under raw, mean + sd and mean
detection regimes. The fourth item is a dataframe of counts of peaks
per taxon, 1 row per taxon, 1 column per detection regime
}
\description{
Function to scan, column-wise, a matrix of per-taxon observation
density time series. This can be applied to either the histogram
or the kernel density output of \code{densify}, but the latter is
recommended. Peaks are detected as local maxima, then smoothed
within a local window and tested to distinguish if they are
noise or significant. Strict threshold is that the peak is
greater than the mean + sd of the window
}
\examples{
# load dataset
data("brachios")
# subsample brachios to make for a short example runtime
set.seed(1)
brachios <- brachios[sample(1:nrow(brachios), 1000),]
# get density matrix
dens <- densify(brachios)
# run function, using kernel density matrix
pk <- find_peaks(dens$kdensity)
}
