% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.ULDA}
\alias{plot.ULDA}
\title{Plot Decision Boundaries and Linear Discriminant Scores}
\usage{
\method{plot}{ULDA}(x, datX, response, ...)
}
\arguments{
\item{x}{A fitted ULDA model object.}

\item{datX}{A data frame containing the predictor variables.}

\item{response}{A factor representing the response variable (training labels)
corresponding to \code{datX}.}

\item{...}{Additional arguments.}
}
\value{
A \code{ggplot2} plot object, either a density plot or a scatter plot with
decision boundaries.
}
\description{
This function plots the decision boundaries and linear discriminant (LD)
scores for a given ULDA model. If it is a binary classification problem, a
density plot is created. Otherwise, a scatter plot with decision boundaries
is generated.
}
\examples{
fit <- folda(datX = iris[, -5], response = iris[, 5], subsetMethod = "all")
plot(fit, iris[, -5], iris[, 5])
}
