% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cran_results.R
\name{cran_results}
\alias{cran_results}
\title{Table of the CRAN check results}
\usage{
cran_results(
  email = NULL,
  pkg = NULL,
  show = c("error", "fail", "warn", "note", "ok"),
  src = c("website", "crandb"),
  ...
)
}
\arguments{
\item{email}{email address for package maintainers (character
vector)}

\item{pkg}{package names (character vector)}

\item{show}{columns of the data frame to show (all are shown by
default)}

\item{src}{if \code{"website"} the data is scrapped from the CRAN
website, if \code{"crandb"} the data is downloaded from a RDS
file hosted on the CRAN servers (which is used to generate the
information found on the CRAN website).}

\item{...}{additional arguments to control where the data from the
check results are coming from and how they are downloaded from
the CRAN servers (see Details section).}
}
\value{
a data frame that tabulates the number of CRAN flavors
that return errors, warnings, notes, or OK for the packages.
}
\description{
Make a table that summarizes the results of the CRAN checks for a
set of packages specified by a maintainer or by names.
}
\details{
Given the email address of a package maintainer, and/or a vector
of package names, returns a tibble that allows you to detect
potential issues with your packages on CRAN.

Where does the data come from?

The data comes from the CRAN servers. They generate RDS files that
contains information regarding the results of the checks for all
the packages, and all the flavors. This data is then used to
generate the web pages.

\code{foghorn} provides access to either of these data sources. If
you choose \code{src = "website"} the data is scrapped from the
CRAN website. If you only need to check a few packages, this is a
good option. If you choose \code{src = "crandb"} the RDS files
(about 20Mb) are downloaded first from the CRAN servers.

When choosing \code{src = "crandb"} you can also specify the
following options:
\itemize{
\item \code{dest}:  a folder where to store the RDS files (\code{tempdir()}
by default).
\item \code{protocol}: either \code{https} or \code{http}.
\item \code{overwrite}: when \code{FALSE} (default), if the file exists in
\code{dest} then it will not be downloaded again. When
\code{TRUE} the file gets downloaded every time it's
needed.
}
}
\examples{
  \dontrun{
    cran_results(pkg="MASS")
  }
}
\seealso{
Note that the \code{tools} package contains unexported
functions that can be used to extract summary information from
the check results. Specifically
\code{tools:::sumarize_CRAN_check_status} is similar to
\code{show_cran_results}.
}
