% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fmesher_subdivide}
\alias{fmesher_subdivide}
\title{Subdivide triangles}
\usage{
fmesher_subdivide(
  mesh_loc,
  mesh_tv,
  mesh_boundary,
  mesh_interior,
  subdivisions,
  options
)
}
\arguments{
\item{mesh_loc}{numeric matrix; mesh vertex coordinates}

\item{mesh_tv}{3-column integer matrix with 0-based vertex indices for each triangle}

\item{mesh_boundary}{2-column integer matrix with 0-based vertex indices for
boundary constraints, currently ignored}

\item{mesh_interior}{2-column integer matrix with 0-based vertex indices for
interior constraints, currently ignored}

\item{subdivisions}{integer; number of new points along each edge.}

\item{options}{list of triangulation options (\code{sphere_tolerance})}
}
\value{
A list of new \code{loc} and \code{tv} information
}
\description{
Subdivide a mesh with congruent and anti-congruent subtriangles
}
\examples{
mesh <- fm_mesh_2d(
  boundary = fm_segm(rbind(c(0,0), c(1,0), c(1,1), c(0, 1)), is.bnd = TRUE)
)
new_mesh <- fm_subdivide(mesh, n = 3)
plot(new_mesh, edge.color = 2)
plot(mesh, add = TRUE, edge.color = 1)
}
\seealso{
\code{\link[=fm_subdivide]{fm_subdivide()}}
}
\keyword{internal}
