% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_lines.R
\name{fm_split_lines}
\alias{fm_split_lines}
\alias{fm_split_lines.fm_mesh_2d}
\alias{fm_split_lines.inla.mesh}
\title{Split lines at triangle edges}
\usage{
fm_split_lines(mesh, ...)

\method{fm_split_lines}{fm_mesh_2d}(mesh, segm, ...)

\method{fm_split_lines}{inla.mesh}(mesh, ...)
}
\arguments{
\item{mesh}{An \code{fm_mesh_2d} or \code{inla.mesh} object}

\item{...}{Unused.}

\item{segm}{An \code{\link[=fm_segm]{fm_segm()}} object with segments to be split}
}
\value{
An \code{\link[=fm_segm]{fm_segm()}} object with the same crs as the mesh,
with an added field \code{origin}, that for each new segment gives the
originator index into to original \code{segm} object for each new line segment.
}
\description{
Compute intersections between line segments and triangle edges,
and filter out segment of length zero.
}
\examples{
mesh <- fm_mesh_2d(
  boundary = fm_segm(
    rbind(c(0, 0), c(1, 0), c(1, 1), c(0, 1)),
    is.bnd = TRUE
  )
)
splitter <- fm_segm(rbind(c(0.8, 0.2), c(0.2, 0.8)))
segm_split <- fm_split_lines(mesh, splitter)

plot(mesh)
lines(splitter)
points(segm_split$loc)
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
