% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date-counters.R
\name{year_frac}
\alias{year_frac}
\title{The years between two dates for a given day basis convention}
\usage{
year_frac(date1, date2, day_basis, maturity_date = NULL)
}
\arguments{
\item{date1}{A vector of dates. This will be coerced to a \code{\link{Date}}
class.}

\item{date2}{A vector of dates. This will be coerced to a \code{\link{Date}}
class.}

\item{day_basis}{The basis on which the year fraction is calculated. See
\code{\link[=is_valid_day_basis]{is_valid_day_basis()}}}

\item{maturity_date}{a vector of dates representing the maturity date of
the instrument. Only used for 30E/360 ISDA day basis.}
}
\value{
a numeric vector representing the number of years between
\code{date1} and \code{date2}.
}
\description{
This calculates the years between two dates using the given day
basis convention.
}
\details{
The order of \code{date1} and \code{date2} is not important. If \code{date1}
is less than \code{date2} then the result will be non-negative. Otherwise,
the result will be negative. The parameters will be repeated with recycling
such that each parameter's length is equal to maximum length of
any of the parameters.
}
\examples{
require(lubridate)
year_frac(ymd("2010-03-31"), ymd("2012-03-31"), "30/360us") # 2
year_frac(ymd("2010-02-28"), ymd("2012-03-31"), "act/360")  # 2.116667
year_frac(ymd("2010-02-28"), ymd("2012-03-31"), "act/365")  # 2.087671
year_frac(ymd("2010-02-28"), ymd("2012-03-31"), "act/actisda")  # 2.086998
}
\references{
\url{http://en.wikipedia.org/wiki/Day_count_convention}
}
\seealso{
Other counter methods: \code{\link{actual_360}},
  \code{\link{actual_365}},
  \code{\link{actual_actual_isda}},
  \code{\link{is_valid_day_basis}},
  \code{\link{thirty_360_eu_isda}},
  \code{\link{thirty_360_eu_plus}},
  \code{\link{thirty_360_eu}}, \code{\link{thirty_360_us}},
  \code{\link{thirty_360}}
}
