% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/to-flow.R
\name{to_flow}
\alias{flowr}
\alias{is.flow}
\alias{to_flow}
\alias{to_flow.character}
\alias{to_flow.data.frame}
\alias{to_flow.flowmat}
\alias{to_flow.list}
\title{Create flow objects}
\usage{
to_flow(x, ...)

is.flow(x)

\method{to_flow}{character}(x, def, grp_col, jobname_col, cmd_col, ...)

\method{to_flow}{flowmat}(x, def, grp_col, jobname_col, cmd_col, flowname,
  flow_run_path, platform, submit = FALSE, execute = FALSE, qobj,
  verbose = get_opts("verbose"), ...)

\method{to_flow}{data.frame}(x, ...)

\method{to_flow}{list}(x, def, flowname, flow_run_path, desc, qobj,
  verbose = get_opts("verbose"), ...)
}
\arguments{
\item{x}{path (char. vector) to flow_mat, a data.frame or a list.}

\item{...}{Supplied to specific functions like \code{to_flow.data.frame}}

\item{def}{A flow definition table. Basically a table with resource requirements and mapping of the jobs in this flow}

\item{grp_col}{column name used to split x (flow_mat). [samplename]}

\item{jobname_col}{column name with job names. [jobname]}

\item{cmd_col}{column name with commands. [cmd]}

\item{flowname}{name of the flow [flowname]}

\item{flow_run_path}{Path to a folder. Main operating folder for this flow. [\code{get_opts("flow_run_path")}]
[\code{~/flowr/runs}].}

\item{platform}{character vector, specifying the platform to use. local, lsf, torque, moab, sge, slurm, ...
This over-rides the platform column in flowdef. (optional)}

\item{submit}{Use submit_flow on flow object this function returns. TRUE/FALSE. [FALSE]}

\item{execute}{Use submit_flow on flow object this function returns. TRUE/FALSE, an paramter to submit_flow(). [FALSE]}

\item{qobj}{Depreciated, modify \href{http://docs.flowr.space/docs.html#cluster-support}{cluster templates} instead.  A object of class \link{queue}.}

\item{verbose}{A numeric value indicating the amount of messages to produce.
 Values are integers varying from 0, 1, 2, 3, .... Please refer to the \link{verbose} page for more details.
[\code{get_opts("verbose")}] [1]}

\item{desc}{Advanced Use. final flow name, please don't change.}
}
\value{
Returns a flow object. If execute=TRUE, fobj is rich with information about where and how
the flow was executed. It would include details like jobids, path to exact scripts run etc.
To use kill_flow, to kill all the jobs one would need a rich flow object, with job ids present.

\strong{Behaviour:}{
What goes in, and what to expect in return?
\itemize{
\item submit=FALSE & execute=FALSE: Create and return a flow object
\item submit=TRUE & execute=FALSE: dry-run, Create a flow object then, create a structured execution folder with all the commands
\item submit=TRUE, execute=TRUE: Do all of the above and then, submit to cluster
}
}
}
\description{
Use a set of shell commands and flow definiton to create \link{flow} object.

vector: a file with flowmat table

a named list of commands for a sample. Its best to supply a flowmat instead.
}
\details{
The parameter x can be a path to a flow_mat, or a data.frame (as read by read_sheet).
This is a minimum three column matrix with three columns: samplename, jobname and cmd
}
\examples{
## Use this link for a few elaborate examples:
## http://docs.flowr.space/flowr/tutorial.html#define_modules

ex = file.path(system.file(package = "flowr"), "pipelines")
flowmat = as.flowmat(file.path(ex, "sleep_pipe.tsv"))
flowdef = as.flowdef(file.path(ex, "sleep_pipe.def"))
fobj = to_flow(x = flowmat, def = flowdef, flowname = "sleep_pipe", platform = "lsf")


## create a vector of shell commands
cmds = c("sleep 1", "sleep 2")
## create a named list
lst = list("sleep" = cmds)
## create a flowmat
flowmat = to_flowmat(lst, samplename = "samp")

## Use flowmat to create a skeleton flowdef
flowdef = to_flowdef(flowmat)

## use both (flowmat and flowdef) to create a flow
fobj = to_flow(flowmat, flowdef)

## submit the flow to the cluster (execute=TRUE) or do a dry-run (execute=FALSE)
\dontrun{
fobj2 = submit_flow(fobj, execute=FALSE)
fobj3 = submit_flow(fobj, execute=TRUE)

## Get the status or kill all the jobs
status(fobj3)
kill(fobj3)
}
}
\seealso{
\link{to_flowmat}, \link{to_flowdef}, \link{to_flowdet}, \link{flowopts} and \link{submit_flow}
}

