% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_flextable_gam.R
\name{as_flextable.gam}
\alias{as_flextable.gam}
\title{tabular summary for gam object}
\usage{
\method{as_flextable}{gam}(x, ...)
}
\arguments{
\item{x}{gam model}

\item{...}{unused argument}
}
\description{
produce a flextable describing a
generalized additive model produced by function \code{mgcv::gam}.
}
\section{Illustrations}{


\if{html}{\figure{fig_as_flextable.gam_1.png}{options: width=60\%}}
}

\examples{
if (require("mgcv")) {
  set.seed(2)

  # Simulated data
  dat <- gamSim(1, n = 400, dist = "normal", scale = 2)

  # basic GAM model
  b <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = dat)

  ft <- as_flextable(b)
  ft
}
}
\seealso{
Other as_flextable methods: 
\code{\link{as_flextable.glm}()},
\code{\link{as_flextable.grouped_data}()},
\code{\link{as_flextable.htest}()},
\code{\link{as_flextable.lm}()},
\code{\link{as_flextable.xtable}()},
\code{\link{as_flextable}()}
}
\concept{as_flextable methods}
