% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_excel_folder.R
\name{read_excel_folder}
\alias{read_excel_folder}
\title{Import one sheet from each Excel file in a folder}
\usage{
read_excel_folder(
  folder,
  sheetIndex = 1,
  sheetName = NULL,
  encoding = "UTF-8",
  password = NULL
)
}
\arguments{
\item{folder}{A string, folder name.}

\item{sheetIndex}{A number, sheet index in the workbook.}

\item{sheetName}{A string, sheet name.}

\item{encoding}{A string, encoding to be assumed for input strings.}

\item{password}{A string with the password (if required).}
}
\value{
A \code{pivot_table} object list.
}
\description{
Reads one sheet from each of the Excel files in a folder and creates a list
of \code{pivot_table} objects, one from each sheet or, which is the same in this
case, one from each file. Each sheet is expected to contain a pivot table.
Each line in a file corresponds to a row in a table. File and sheet names are
included as part of each object attributes.
}
\details{
When multiple files or sheets are handled, the file and/or sheet names may
contain information associated with the pivot table, they could be the table
page information. In order not to lose this information, they are always
stored in each \code{pivot_table} object.
}
\examples{
folder <- system.file("extdata", "excelfolder", package = "flattabler")
# lpt <- read_excel_folder(folder)

}
\seealso{


Other import functions: 
\code{\link{pivot_table}()},
\code{\link{read_excel_file}()},
\code{\link{read_excel_sheet}()},
\code{\link{read_text_file}()},
\code{\link{read_text_folder}()}
}
\concept{import functions}
