% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flashlight.R
\name{flashlight}
\alias{flashlight}
\alias{flashlight.default}
\alias{flashlight.flashlight}
\title{Create or Update a flashlight}
\usage{
flashlight(x, ...)

\method{flashlight}{default}(
  x,
  model = NULL,
  data = NULL,
  y = NULL,
  predict_function = predict,
  linkinv = function(z) z,
  w = NULL,
  by = NULL,
  metrics = list(rmse = rmse),
  label = NULL,
  shap = NULL,
  ...
)

\method{flashlight}{flashlight}(x, check = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{flashlight}. If not provided, a new flashlight is created based on further input. Otherwise, \code{x} is updated based on further input.}

\item{...}{Arguments passed from or to other functions.}

\item{model}{A fitted model of any type. Most models require a customized \code{predict_function}.}

\item{data}{A \code{data.frame} or \code{tibble} used as basis for calculations.}

\item{y}{Variable name of response.}

\item{predict_function}{A real valued function with two arguments: A model and a data of the same structure as \code{data}. Only the order of the two arguments matter, not their names.}

\item{linkinv}{An inverse transformation function applied after \code{predict_function}.}

\item{w}{A variable name of case weights.}

\item{by}{A character vector with names of grouping variables.}

\item{metrics}{A named list of metrics. Here, a metric is a function with exactly four arguments: actual, predicted, w (case weights) and \code{...} like those in package \code{MetricsWeighted}.}

\item{label}{Name of the flashlight. Required.}

\item{shap}{An optional shap object. Typically added by calling \code{add_shap}.}

\item{check}{When updating the flashlight: Should internal checks be performed? Default is \code{TRUE}.}
}
\value{
An object of class \code{flashlight} (and \code{list}) containing each input (except \code{x}) as element.
}
\description{
Creates or updates a \code{flashlight} object. If a flashlight is to be created, all arguments are optional except \code{label}. If a flashlight is to be updated, all arguments are optional up to \code{x} (the flashlight to be updated).
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Used to create a flashlight object. No \code{x} has to be passed in this case.

\item \code{flashlight}: Used to update an existing flashlight object.
}}

\examples{
fit <- lm(Sepal.Length ~ ., data = iris)
(fl <- flashlight(model = fit, data = iris, y = "Sepal.Length", label = "ols"))
(fl_updated <- flashlight(fl, linkinv = exp))
}
\seealso{
\code{\link{multiflashlight}}.
}
