% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decorate_code.R
\name{decorate_code}
\alias{decorate_code}
\title{Creates an object of the class \code{with_flair}}
\usage{
decorate_code(text, ...)
}
\arguments{
\item{text}{A string, presumably representing R code.}

\item{...}{Any number of default chunk options to override.}
}
\value{
A \code{with_flair} object.
}
\description{
Creates an object of the class \code{with_flair}
}
\examples{

# When run in console, this will print the results of mean(1:10)
my_code <- decorate_code(text = 'mean(1:10)') \%>\% flair_funs()

# The object itself, when printed, previews your code with flair
\donttest{
my_code
}

# Objects defined by decorate_code are created in the current environment for later use.

my_code <- decorate_code('foo <- mean(1:10)')

foo + 5

}
\seealso{
\code{\link{flair}}
}
