% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBarrierTree2D.R
\name{plotBarrierTree2D}
\alias{plotBarrierTree2D}
\title{Plot Barrier Tree in 2D}
\usage{
plotBarrierTree2D(feat.object, control)
}
\arguments{
\item{feat.object}{[\code{\link{FeatureObject}}]\cr
A feature object as created by \code{\link{createFeatureObject}}.}

\item{control}{[\code{list}]\cr
A \code{list}, which stores additional control arguments.
For further information, see details.}
}
\value{
[\code{plot}].\cr
  A 2D image, visualizing the barrier tree of this cell mapping.
}
\description{
Creates a 2D image containing the barrier tree of this cell mapping.
}
\details{
Possible \code{control} arguments are:
  \itemize{
    \item{Computation of Cell Mapping}: \itemize{
      \item{\code{gcm.approach}}: Which approach should be used when
      computing the representatives of a cell. The default is \code{"min"},
      i.e. the observation with the best (minimum) value within per cell.
      \item{\code{gcm.cf_power}}: Theoretically, we need to compute the
      canonical form to the power of infinity. However, we use this value
      as approximation of infinity. The default is \code{256}.
    }
    \item{Plot Control}: \itemize{
      \item{\code{bt.cm_surface}}: Should the underlying surface be based
      on a cell mapping plot (default is \code{TRUE})? Alternatively, the
      cells would be coloured in shades of grey - according to their
      objective values.
      \item{\code{bt.margin}}: Margins of the plot as used by
      \code{par("mar")}. The default is \code{c(5, 5, 4, 4)}.
      \item{\code{bt.color_surface}}: Color of the surface of the
      perspective plot. The default is \code{"lightgrey"}.
      \item{\code{bt.color_branches}}: Color used for the branches of the
      barrier tree. Per default there will be one color per level.
      \item{\code{bt.pch_root}}: Symbol used for plotting the root.
      The default is \code{17}.
      \item{\code{bt.pch_breakpoint}}: Symbol used for plotting a
      breakpoint. The default is \code{1}.
      \item{\code{bt.pch_basin}}: Symbol used for plotting the leaf (i.e. a
      basin) of the barrier tree. The default is \code{19}.
      \item{\code{bt.col_root}}: Color of the root symbol. The default is
      \code{"red"}.
      \item{\code{bt.lwd}}: Width of the lines used for plotting the
      branches of a barrier tree. The default is \code{2}.
      \item{\code{bt.label.{x, y}_coord}}: Label of the x-/y-coordinate
      (below / left side of the plot).
      \item{\code{bt.label.{x, y}_id}}: Label of the x-/y-cell ID (above /
      right side of the plot).
    }
  }
}
\examples{
# create a feature object
X = createInitialSample(n.obs = 900, dim = 2)
f = smoof::makeAckleyFunction(dimensions = 2)
y = apply(X, 1, f)
feat.object = createFeatureObject(X = X, y = y, fun = f, blocks = c(4, 6))

# plot the corresponing barrier tree
plotBarrierTree2D(feat.object)
}

