% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/term-class.R
\docType{class}
\name{Term-class}
\alias{Term-class}
\alias{DateRangeTerm-class}
\title{Term class}
\description{
It is the time interval used in calculations with interest rates.
The Term class represents the period used to discount or compound a spot
rate.
}
\details{
The Term object is defined by its numeric value and its unit, that can be
\code{"days"}, \code{"months"} or \code{"years"}.
For example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{term(6, "months")
#> [1] "6 months"
}\if{html}{\out{</div>}}

It represents a period of 6 months.
The Term object can also be created from a string representation of a Term.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{as.term("6 months")
#> [1] "6 months"
}\if{html}{\out{</div>}}

Since the Term object inherits from a \code{numeric}, it inherits all numeric
operations.
Numeric values can be summed or subtracted from a Term object numeric part.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{term(1, "days") + 1
#> [1] "2 days"
}\if{html}{\out{</div>}}

Arithmetic and comparison operations between Term object are not implemented,
so these operations raise an error.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{try(term(1, "days") + term(2 , "days"))
#> Error in term(1, "days") + term(2, "days") : Not implemented
}\if{html}{\out{</div>}}
\subsection{DateRangeTerm objects}{

The DateRangeTerm class inherits Term and defines start and end dates
and a calendar to count the amount of working days between these two dates.
This is a Term between two dates.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{term(Sys.Date() - 5, Sys.Date(), "Brazil/ANBIMA")
#> [1] "3 days"
}\if{html}{\out{</div>}}

In financial markets it is fairly usual to evaluate interest rates between
two dates.
}
}
