% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compound-method.R
\name{compound}
\alias{compound}
\alias{compound,Continuous,numeric,numeric-method}
\alias{compound,Discrete,numeric,numeric-method}
\alias{compound,ForwardRate,missing,missing-method}
\alias{compound,Simple,numeric,numeric-method}
\alias{compound,SpotRate,Date,Date-method}
\alias{compound,SpotRate,Term,missing-method}
\alias{compound,SpotRate,numeric,character-method}
\alias{compound,SpotRateCurve,missing,missing-method}
\alias{compound,character,numeric,numeric-method}
\alias{discount,ForwardRate,missing,missing-method}
\alias{discount,SpotRate,Date,Date-method}
\alias{discount,SpotRate,Term,missing-method}
\alias{discount,SpotRate,numeric,character-method}
\alias{discount,SpotRateCurve,missing,missing-method}
\alias{discount}
\title{Compound method}
\usage{
compound(x, t, val, ...)

discount(x, t, val, ...)
}
\arguments{
\item{x}{can be a \code{Compounding}, a \code{SpotRate},
a \code{SpotRateCurve}, a \code{ForwardRate} and a character
representing a \code{Compounding}.}

\item{t}{represents the term to compound. Can be a numeric, a \code{Term},
a \code{Date} or even missing. See Details.}

\item{val}{is the value of the spot rate to be compounded in the given term.
Can be a numeric, a \code{Date} or missing. See Details.}

\item{...}{additional arguments.}
}
\value{
A numeric value that represents the compounding factor for the given
spot rate.
}
\description{
Computes the compounding (and discount) factor for spot rates and curves.
}
\details{
For \code{Compounding} classes the arguments \code{t} and \code{val} must be
provided.

For a \code{SpotRate} class, if the \code{t} argument is numeric,
representing the term to be compounded, the argument \code{val} must
be a character with the units of the Term class. If otherwise \code{t}
is a Term object, \code{val} is missing.

For \code{SpotRateCurve} and \code{ForwardRate} classes, that already have
terms associated, \code{t} and \code{val} are missing.

\code{discount()} method is the inverse of compound: \code{1 / compound()}.
}
\examples{
compound("simple", 2, 0.05)
compound("discrete", 2, 0.05)
compound("continuous", 2, 0.05)

spr <- spotrate(0.06, "simple", "actual/365", "actual")
compound(spr, 10, "days")
discount(spr, 10, "days")
t <- term(10, "days")
compound(spr, t)
discount(spr, t)
d1 <- Sys.Date()
d2 <- Sys.Date() + 10
compound(spr, d1, d2)
discount(spr, d1, d2)

terms <- c(1, 11, 26, 27, 28)
rates <- c(0.0719, 0.056, 0.0674, 0.0687, 0.07)
curve <- spotratecurve(rates, terms, "discrete", "actual/365", "actual")
compound(curve)
discount(curve)
}
