% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CorrBin.R
\name{fitCorrBin}
\alias{fitCorrBin}
\title{Fitting the Correlated Binomial Distribution when binomial
random variable, frequency, probability of success and covariance are given}
\usage{
fitCorrBin(x,obs.freq,p,cov,print)
}
\arguments{
\item{x}{vector of binomial random variables}

\item{obs.freq}{vector of frequencies}

\item{p}{single value for probability of success}

\item{cov}{single value for covariance}

\item{print}{logical value for print or not}
}
\value{
The output of \code{fitCorrBin} gives a list format consisting

\code{bin.ran.var} binomial random variables

\code{obs.freq} corresponding observed frequencies

\code{exp.freq} corresponding expected frequencies

\code{statistic} chi-squared test statistics

\code{df} degree of freedom

\code{p.value} probability value by chi-squared test statistic

\code{corr}    Correlation value
}
\description{
The function will fit the Correlated binomial Distribution
when random variables, corresponding frequencies, probability of success and covariance are given.
It will provide the expected frequencies, chi-squared test statistics value, p value,
and degree of freedom so that it can be seen if this distribution fits the data.
}
\details{
\deqn{obs.freq \ge 0}
\deqn{x = 0,1,2,..}
\deqn{0 < p < 1}
\deqn{-\infty < cov < +\infty}

\strong{NOTE} : If input parameters are not in given domain conditions
necessary error messages will be provided to go further
}
\examples{
No.D.D=0:7                    #assigning the random variables
Obs.fre.1=c(47,54,43,40,40,41,39,95)      #assigning the corresponding frequencies

#estimating the parameters using maximum log likelihood value and assigning it
parameters=suppressWarnings(bbmle::mle2(EstMLECorrBin,start = list(p=0.5,cov=0.0050),
           data = list(x=No.D.D,freq=Obs.fre.1)))
pCorrBin=bbmle::coef(parameters)[1]
covCorrBin=bbmle::coef(parameters)[2]
#fitting when the random variable,frequencies,probability and covariance are given
fitCorrBin(No.D.D,Obs.fre.1,pCorrBin,covCorrBin)
#extracting the expected frequencies
fitCorrBin(No.D.D,Obs.fre.1,pCorrBin,covCorrBin,FALSE)$exp.freq
}
\references{
Johnson, N. L., Kemp, A. W., & Kotz, S. (2005). Univariate discrete distributions (Vol. 444).
Hoboken, NJ: Wiley-Interscience.

L. L. Kupper, J.K.H., 1978. The Use of a Correlated Binomial Model for the Analysis of Certain Toxicological
Experiments. Biometrics, 34(1), pp.69-76.

Paul, S.R., 1985. A three-parameter generalization of the binomial distribution. Communications in Statistics
- Theory and Methods, 14(6), pp.1497-1506.

Available at: \url{http://www.tandfonline.com/doi/abs/10.1080/03610928508828990} .

Jorge G. Morel and Nagaraj K. Neerchal. Overdispersion Models in SAS. SAS Institute, 2012.
}
