% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{production_imbalance_electricity_sales_price}
\alias{production_imbalance_electricity_sales_price}
\title{The sales price of production imbalance electricity}
\usage{
production_imbalance_electricity_sales_price(
  start_time = NA,
  end_time = NA,
  user_key = NA
)
}
\arguments{
\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains the up-regulating price of the
hour is the price of production imbalance power sold by Fingrid to a
balance responsible party. If no up regulation has been made or if the
hour has been defined as a down-regulation hour, the day ahead spot
price of Finland is used as the selling price of production imbalance
power. Separate production balance ended when 1.11.2021 01.00
settlement model was changed to single imbalance.
}
\description{
Check https://data.fingrid.fi/en/dataset/the-sales-price-of-production-imbalance-electricity
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- production_imbalance_electricity_sales_price(start_time = start,
    end_time = end,
    user_key = key)
summary(df)
}
}
