% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_les.R
\name{get_les}
\alias{get_les}
\title{Get Legislative Effectiveness Scores data}
\usage{
get_les(chamber, les_2 = FALSE, local = TRUE, local_dir = ".")
}
\arguments{
\item{chamber}{Which chamber to get data for. Options are:
\itemize{
\item \code{"house"}, \code{"h"}, \code{"hr"}: House data only.
\item \code{"senate"}, \code{"s"}, \code{"sen"}: Senate data only.
}

These options are case-insensitive. Any other argument results in an error.

\strong{Note:} Unlike the Voteview functions, there is no \code{"all"} option.
You \emph{must} specify either House or Senate data, since there is no
"default" option.

There are non-trivial differences between the House and Senate datasets,
so take care when joining House and Senate data.
Important differences include:
\itemize{
\item \strong{Legislator names} are formatted differently. The Senate data has
\code{first} and \code{last} name columns, while the House data has a single
\code{thomas_name} column.
\item \strong{The \code{year} column} refers to the first year of the Congress in the
House data, but \code{year} refers to the preceding election year in the
Senate data. Thus, the \code{year} for House members is one after that of
senators in the same Congress.
}}

\item{les_2}{Whether to use LES 2.0 (instead of Classic Legislative
Effectiveness Scores).  LES 2.0 credits lawmakers when language
from their sponsored bills is included in other legislators' bills
that become law. LES 2.0 is only available for the 117th Congress.
Classic LES is available for the 93rd through 117th Congresses.}

\item{local}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Whether to read the data from a local file, as opposed to the Center for Effective Lawmaking website. Default is \code{TRUE}. If the local file does not exist, will fall back to reading from online.}

\item{local_dir}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} The directory containing
the local file. Defaults to the working directory.}
}
\value{
A \code{\link[=tibble]{tibble()}}.
}
\description{
\code{get_les()} returns \href{https://thelawmakers.org/data-download}{Legislative Effectiveness Scores data}
from the Center for Effective Lawmaking.
}
\details{
See the \href{https://thelawmakers.org}{Center for Effective Lawmaking}
website for more information on their data.

The Legislative Effectiveness Score methodology was introduced in:

Volden, C., & Wiseman, A. E. (2014). \emph{Legislative effectiveness in the
United States Congress: The lawmakers}. Cambridge University Press.
\doi{doi:10.1017/CBO9781139032360}
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Classic LES data (93rd-117th Congresses)
get_les("house", les_2 = FALSE)
get_les("senate", les_2 = FALSE)
\dontshow{\}) # examplesIf}
# LES 2.0 (117th Congress)
get_les("house", les_2 = TRUE)
get_les("senate", les_2 = TRUE)
}
