% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{filearray}
\alias{filearray}
\alias{filearray_create}
\alias{filearray_load}
\title{Create or load existing file arrays}
\usage{
filearray_create(
  filebase,
  dimension,
  type = c("double", "integer", "logical", "raw"),
  partition_size = NA
)

filearray_load(filebase, mode = c("readwrite", "readonly"))
}
\arguments{
\item{filebase}{a directory path to store arrays in the local file 
system. When creating an array, the path must not exist.}

\item{dimension}{dimension of the array, at least length of 2}

\item{type}{storage type of the array; default is \code{'double'}. Other
options include \code{'integer'}, \code{'logical'}, and \code{'raw'}.}

\item{partition_size}{positive partition size for the last margin, or
\code{NA} to automatically guess; see 'Details'.}

\item{mode}{whether allows writing to the file; choices are 
\code{'readwrite'} and \code{'readonly'}.}
}
\value{
A \code{\link{FileArray-class}} instance.
}
\description{
Create or load existing file arrays
}
\details{
The file arrays partition out-of-memory array objects and store them 
separately in local file systems. Since R stores matrices/arrays 
in column-major style, file array uses the slowest margin (the 
last margin) to slice the partitions. This helps to align the elements
within the files with the corresponding memory order. An array with 
dimension \code{100x200x300x400} has 4 margins. The length of the 
last margin is 400, which is also the maximum number of potential
partitions. The number of partitions are determined by the last margin
size divided by \code{partition_size}. For example, if the partition
size is 1, then there will be 400 partitions. If the partition size 
if 3, there will be 134 partitions. The default partition sizes 
are determined internally following these priorities:
\describe{
\item{1. }{the file size of each partition does not exceed \code{1GB}}
\item{2. }{the number of partitions do not exceed 100}
}
These two rules are not hard requirements. The goal is to reduce the
numbers of partitions as much as possible.
}
\examples{


# Prepare 
library(filearray)
filebase <- tempfile()
if(file.exists(filebase)){ unlink(filebase, TRUE) }

# create array
x <- filearray_create(filebase, dimension = c(200, 30, 8))
print(x)

# Assign values
x[] <- rnorm(48000)

# Subset
x[1,2,]

# load existing array
filearray_load(filebase)



}
\author{
Zhengjia Wang
}
