% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rf.pred.R
\name{rfPred}
\alias{rfPred}
\title{Variable selection in Random Forest}
\usage{
rfPred(object, importance = "permutation", nfor.pred = 25, nmj = 1,
  outfile = "rfPred.file", named.file = "rfPredResults", ...)
}
\arguments{
\item{object}{an object returned from \code{\link{rfInterp}}}

\item{importance}{what importance measure should be used? Either "permutation" or "gini."}

\item{nfor.pred}{number of forests to grow}

\item{nmj}{a contant used for setting the threshold for variable selection. Higher values indicate a less stringent threshold.}

\item{outfile}{The file location where the rfPred object should be stored. Defaults to storing it in rfPred.file in the default directory.}

\item{named.file}{What should the rfPred object be named when saved? Defaults to "rfPredResults".}

\item{...}{other arguments passed to \code{\link{cforest}} or \code{\link{randomForest}}}
}
\value{
\item{varselect.pred}{The variables selected for Prediction (sorted)}

\item{err.interp}{The error at each stage of the stepwise variable inclusion.}

\item{mean.jump}{The threshold for variable inclusion.}

\item{stepwise.error}{The OOB error rate at each iteration of the stepwise procedure.}

\item{num.varselect.pred}{The number of variables selected for prediction.}

\item{comput.time}{Computation time of the procedure.}

\item{model}{The final model, either a \code{randomForest} or \code{cforest} object.}
}
\description{
Variable selection for prediction purposes using Random Forest. See \code{\link{rfThresh}} for complete documentation.
}
\examples{
\dontrun{data(iris); 
data = iris; 
formula = as.formula("Species ~ Sepal.Length + Sepal.Width + Petal.Length + Petal.Width")
thresh = rfThresh(formula, data=iris, nruns=2, importance="permutation"); 
interp = rfInterp(thresh, importance="permutation");
predic = rfPred(interp, importance="gini")
predic}
}
\author{
Robin Genuer, Jean-Michel Poggi and Christine Tuleau-Malot, with modifications by Dustin Fife
}
\seealso{
\code{\link{rfInterp}}, \code{\link{rfThresh}}
}

