% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_pibble.R
\name{pibble_fit}
\alias{pibble_fit}
\alias{pibble}
\alias{refit.pibblefit}
\title{Interface to fit pibble models}
\usage{
pibble(
  Y = NULL,
  X = NULL,
  upsilon = NULL,
  Theta = NULL,
  Gamma = NULL,
  Xi = NULL,
  init = NULL,
  pars = c("Eta", "Lambda", "Sigma"),
  ...
)

\method{refit}{pibblefit}(m, pars = c("Eta", "Lambda", "Sigma"), ...)
}
\arguments{
\item{Y}{D x N matrix of counts (if NULL uses priors only)}

\item{X}{Q x N matrix of covariates (design matrix) (if NULL uses priors only, must
be present to sample Eta)}

\item{upsilon}{dof for inverse wishart prior (numeric must be > D)
(default: D+3)}

\item{Theta}{(D-1) x Q matrix of prior mean for regression parameters
(default: matrix(0, D-1, Q))}

\item{Gamma}{QxQ prior covariance matrix
(default: diag(Q))}

\item{Xi}{(D-1)x(D-1) prior covariance matrix
(default: ALR transform of diag(1)*(upsilon-D)/2 - this is
essentially iid on "base scale" using Aitchison terminology)}

\item{init}{(D-1) x Q initialization for Eta for optimization}

\item{pars}{character vector of posterior parameters to return}

\item{...}{arguments passed to \code{\link{optimPibbleCollapsed}} and
\code{\link{uncollapsePibble}}}

\item{m}{object of class pibblefit}
}
\value{
an object of class pibblefit
}
\description{
This function is largely a more user friendly wrapper around
\code{\link{optimPibbleCollapsed}} and
\code{\link{uncollapsePibble}}.
See details for model specification.
Notation: \code{N} is number of samples,
\code{D} is number of multinomial categories, \code{Q} is number
of covariates, \code{iter} is the number of samples of \code{eta} (e.g.,
the parameter \code{n_samples} in the function
\code{\link{optimPibbleCollapsed}})
}
\details{
the full model is given by:
\deqn{Y_j \sim Multinomial(Pi_j)}
\deqn{Pi_j = Phi^{-1}(Eta_j)}
\deqn{Eta \sim MN_{D-1 x N}(Lambda*X, Sigma, I_N)}
\deqn{Lambda \sim MN_{D-1 x Q}(Theta, Sigma, Gamma)}
\deqn{Sigma \sim InvWish(upsilon, Xi)}
Where Gamma is a Q x Q covariance matrix, and Phi^{-1} is
ALRInv_D transform.

Default behavior is to use MAP estimate for uncollaping the LTP
model if laplace approximation is not preformed.
}
\examples{
sim <- pibble_sim()
fit <- pibble(sim$Y, sim$X)
}
\references{
JD Silverman K Roche, ZC Holmes, LA David, S Mukherjee. 
  Bayesian Multinomial Logistic Normal Models through Marginally Latent Matrix-T Processes. 
  2019, arXiv e-prints, arXiv:1903.11695
}
\seealso{
\code{\link{fido_transforms}} provide convenience methods for
transforming the representation of pibblefit objects (e.g., conversion to
proportions, alr, clr, or ilr coordinates.)

\code{\link{access_dims}} provides convenience methods for accessing
dimensions of pibblefit object

Generic functions including \code{\link[=summary.pibblefit]{summary}},
\code{\link[=print.pibblefit]{print}},
\code{\link[=coef.pibblefit]{coef}},
\code{\link[=as.list.pibblefit]{as.list}},
\code{\link[=predict.pibblefit]{predict}},
\code{\link[=name.pibblefit]{name}}, and
\code{\link[=sample_prior.pibblefit]{sample_prior}}
\code{\link{name_dims}}

Plotting functions provided by \code{\link[=plot.pibblefit]{plot}}
and \code{\link[=ppc.pibblefit]{ppc}} (posterior predictive checks)
}
