% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_entries.R
\name{fhir_rm_indices}
\alias{fhir_rm_indices}
\title{Remove indices from data.frame/data.table}
\usage{
fhir_rm_indices(
  indexed_data_frame,
  brackets = c("<", ">"),
  columns = names(indexed_data_frame)
)
}
\arguments{
\item{indexed_data_frame}{A data frame with indices for multiple entries as produced by \code{\link[=fhir_crack]{fhir_crack()}}}

\item{brackets}{A character vector of length two defining the brackets that were used in \code{\link[=fhir_crack]{fhir_crack()}}}

\item{columns}{A character vector of column names, indicating from which columns indices should be removed.
Defaults to all columns.}
}
\value{
A data frame without indices.
}
\description{
Removes the indices in front of multiple entries as produced by \code{\link[=fhir_crack]{fhir_crack()}} when brackets are provided in
the design.
}
\examples{

#unserialize example
bundles <- fhir_unserialize(bundles = example_bundles1)

patients <- fhir_table_description(resource = "Patient")

df <- fhir_crack(bundles = bundles,
                  design = patients,
                  brackets = c("[", "]"))

df_indices_removed <- fhir_rm_indices(indexed_data_frame = df, brackets=c("[", "]"))

}
\seealso{
\code{\link[=fhir_melt]{fhir_melt()}}
}
