% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_resources.R
\name{fhir_put}
\alias{fhir_put}
\title{PUT to a FHIR server}
\usage{
fhir_put(
  url,
  body,
  username = NULL,
  password = NULL,
  token = NULL,
  add_headers = NULL,
  verbose = 1,
  log_errors = NULL
)
}
\arguments{
\item{url}{An object of class \linkS4class{fhir_url} or a character vector of length one containing the url to PUT to.}

\item{body}{An object of class \linkS4class{fhir_resource} or \linkS4class{fhir_body}. See details for how to generate them.}

\item{username}{A character vector of length one containing the username for basic authentication.}

\item{password}{A character vector of length one containing the password for basic authentication.}

\item{token}{A character vector of length one or object of class \link[httr:Token-class]{httr::Token}, for bearer token authentication (e.g. OAuth2). See \code{\link[=fhir_authenticate]{fhir_authenticate()}}
for how to create this.}

\item{add_headers}{A named character vector of custom headers to add to the HTTP request, e.g. \code{c(myHeader = "somevalue")} or
\code{c(firstHeader = "value1", secondHeader = "value2")}.}

\item{verbose}{An integer vector of length one. If 0, nothing is printed, if > 0 success message is printed. Defaults to 1.}

\item{log_errors}{Either \code{NULL} or a character vector of length one indicating the name of a file in which to save http errors.
\code{NULL} means no error logging. When a file name is provided, the errors are saved in the specified file. Defaults to \code{NULL}.
Regardless of the value of \code{log_errors} the most recent http error message within the current R session is saved internally and can
be accessed with \code{\link[=fhir_recent_http_error]{fhir_recent_http_error()}}.}
}
\description{
This function is a convenience wrapper around \code{\link[httr:PUT]{httr::PUT()}}.
}
\details{
\code{\link[=fhir_put]{fhir_put()}} accepts two classes for the body:
\enumerate{
\item A \linkS4class{fhir_resource} as created by \code{\link[=fhir_build_resource]{fhir_build_resource()}}. This is used when just a single resource should be PUT to the server.
In this case \code{url} must contain the base url plus the resource type and the resource id,
e.g. http://hapi.fhir.org/baseR4/Patient/1a2b3c.
\item A \linkS4class{fhir_body} as created by \code{\link[=fhir_body]{fhir_body()}}. This is the most flexible approach, because within the \linkS4class{fhir_body} object you can represent
any kind of \code{content} as a string and set the \code{type} accordingly. See examples.
}

For examples of how to create the different body types see the respective help pages. For an example of the entire workflow around creating
and PUTing resources, see the package vignette on recreating resources.
}
\examples{
\dontrun{
### 1. PUT fhir__resource object
#unserialize example resource
resource <- fhir_unserialize(example_resource2)

#have a look at the resource
resource

#put
fhir_put(url = "http://hapi.fhir.org/baseR4/Patient/1a2b3c", body = resource)

### 2. PUT fhir_body object
#define body
body <- fhir_body(content = "<Patient> <id value='x1y2'/> <gender value='female'/> </Patient>",
                  type = "xml")

#put
fhir_put(url = "http://hapi.fhir.org/baseR4/Patient/x1y2", body = body)
}
}
