% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_projections_week.R
\name{ffs_generate_projections_week}
\alias{ffs_generate_projections_week}
\title{Generate Projections}
\usage{
ffs_generate_projections_week(
  adp_outcomes,
  latest_rankings,
  n = 1000,
  rosters = NULL
)
}
\arguments{
\item{adp_outcomes}{a dataframe of adp-based weekly outcomes, as created by \code{ffs_adp_outcomes()}}

\item{latest_rankings}{a dataframe of rankings, as created by \code{ffs_latest_rankings()}}

\item{n}{number of weeks to simulate}

\item{rosters}{a dataframe of rosters, as created by \code{ffs_rosters()} - optional, reduces computation to just rostered players}
}
\value{
a dataframe of weekly scores for each player in the simulation, approximately of length n_seasons x n_weeks x latest_rankings
}
\description{
Runs the bootstrapped resampling of player week outcomes on the latest rankings and rosters for a given number of seasons and weeks per season.
}
\examples{
\donttest{
# cached examples
adp_outcomes_week <- .ffs_cache("adp_outcomes_week.rds")
latest_rankings_week <- .ffs_cache("latest_rankings_week.rds")

ffs_generate_projections_week(adp_outcomes_week, latest_rankings_week)
}

}
\seealso{
vignette("custom") for example usage
}
