% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores.R
\name{tidy_scores}
\alias{tidy_scores}
\title{Fantasy matchup scores}
\usage{
tidy_scores(leagueId = ffl_id(), leagueHistory = FALSE, ...)
}
\arguments{
\item{leagueId}{Numeric league ID or ESPN fantasy page URL. Defaults to
\code{getOption("fflr.leagueId")}. Function fails if no ID is found.}

\item{leagueHistory}{logical; Should the \code{leagueHistory} version of the API
be called? If \code{TRUE}, a list of results is returned, with one element for
each historical year of the league.}

\item{...}{Additional queries passed to \code{\link[httr:GET]{httr::GET()}}
(e.g., \code{scoringPeriodId}). Arguments are converted to a named list to be
passed alongside \code{view}.}
}
\value{
A tidy data frame of scores by team and matchup period.
}
\description{
The score of each team in a matchup period and the match outcome.
}
\details{
\code{powerWins} are added by comparing a team score versus every other team
during that matchup period; the highest score would have won against all
teams and the lowest score would have zero wins.
}
\examples{
tidy_scores(leagueId = "42654852")
tidy_scores(leagueId = "252353", leagueHistory = TRUE)
}
