\name{ffappend}
\alias{ffappend}
\title{Append a ff vector to another ff vector}
\usage{
  ffappend(x, y, adjustvmode = TRUE, ...)
}
\arguments{
  \item{x}{\code{ff} object where data will be appended to.
  If \code{x==NULL} a new \code{ff} object will be created}

  \item{y}{\code{ff} object or vector object}

  \item{adjustvmode}{logical, indicating to coerce x to a
  higher \code{vmode} to make sure y is appended without
  loss of information.}

  \item{...}{parameter that will be passed on to
  \code{chunk} interally}
}
\value{
  \code{ff} object with same physical storage as \code{x}
  unless \code{y} has a higher \code{vmode} in which case
  the data will be cloned to the higher \code{vmode}
}
\description{
  Appends (\code{ff}) vector \code{y} to \code{ff} vector
  \code{x}. Please note that the data of \code{x} will be
  coerced to the type of \code{y} if \code{y} has a higher
  \code{vmode}.
}
\seealso{
  \code{\link{c.ff}}
}

