% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ffseq.R
\name{ffseq}
\alias{ffseq}
\title{Sequence Generation of \code{ff} vectors.}
\usage{
ffseq(from = 1, to = 1, by = ((to - from)/(length.out - 1)),
  length.out = NULL, along.with = NULL, ...)
}
\arguments{
\item{from}{the starting value of the sequence}

\item{to}{the end (maximal) value of the sequence}

\item{by}{number, increment of the sequence}

\item{length.out}{desired length of the sequence. Only non-negative numbers larger than 0 are allowed.}

\item{along.with}{take the length from the length of this argument}

\item{...}{arguments passed to or from methods}
}
\value{
An ff vector with the generated sequence, similar as what \code{seq} generates but as an ff vector. \cr
Mark: in case this would generate a sequence of length 0, will return integer().
}
\description{
Similar as \code{seq} in the base package, generating an \code{ff} vector.
}
\examples{
## ffseq_len
ffseq_len(1000)
ffseq_len(1000000)

## ffseq
ffseq(from = 1, to = 4, by = 1)
ffseq(from = 1, to = 4, by = 0.5)
ffseq(from = 4, to = 1, by = -0.5)
ffseq(from = -100, to = 100, by = 0.3)
ffseq(from = 2, to = -100, length.out = 4)
ffseq(from = 2, to = -100, length.out = 4)
ffseq(from = 2, along.with=1000)
ffseq(to = 2, along.with=1000)
ffseq(along.with=1000)
ffseq(length.out=1000000)

}
\seealso{
\code{\link[base]{seq}}
}

