% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/febr2xlsx.R
\name{febr2xlsx}
\alias{febr2xlsx}
\title{Write data to an Excel workbook}
\usage{
febr2xlsx(x, file, row.names = FALSE, ...)
}
\arguments{
\item{x}{A \code{data.frame} or \code{list} of \code{data.frame}s to write to the Excel workbook.}

\item{file}{Character string indicating the path to the output XLSX file.}

\item{row.names}{(optional) Logical value indicating whether the row names of \code{x} are to be written along
with \code{x} to the file.}

\item{...}{(optional) Further arguments passed to \code{\link[xlsx]{write.xlsx}}.}
}
\description{
Write data downloaded from the Free Brazilian Repository for Open Soil Data -- \emph{\strong{febr}},
\url{http://www.ufsm.br/febr} -- to an Excel workbook.
}
\examples{
\donttest{
dts <-
  febr::febr(dataset = "ctb0013", 
             variable = "all",
             merge = TRUE,
             progress = FALSE, verbose = FALSE)
febr2xlsx(x = dts, file = tempfile(fileext = ".xlsx"))
}
}
\author{
Alessandro Samuel-Rosa \email{alessandrosamuelrosa@gmail.com}
}
